<?php

namespace App\Models\Chauffeur;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chauffeur extends Model 
{

    protected $table = 'chauffeurs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function vehicules()
    {
        return $this->hasMany('App\Models\Vehicule\Vehicule');
    }

    public function type_chauffeur()
    {
        return $this->belongsTo('App\Models\TypeChauffeur\TypeChauffeur');
    }

    public function mon_bedou()
    {
        return $this->belongsTo('App\Models\MonBedou\MonBedou');
    }

    public function notations()
    {
        return $this->hasMany('App\Models\Notation\Notation');
    }

    public function bonus_chauffeurs()
    {
        return $this->hasMany('App\Models\BonusChaufeur\BonusChauffeur');
    }

    public function notation_chauffeurs()
    {
        return $this->hasMany('App\Models\NotificationChauffeur\NotificationChauffeur');
    }

}